/* ------------------------------------------------------------------
 * Configuration of ShouldBeBuiltInCalendar
 * 
 * 2024.11.15 Version 1.0.0
 * (C) Akazawa Studio LLC, https://www.akazawa.org
 * ------------------------------------------------------------------*/
(function(PLUGIN_ID) {
	'use strict';
	// ---------------------------
	// 要素の取得
	// ---------------------------
	// 保存ボタン
	const saveButton = document.getElementById('akz-saveButton');
	// 一覧ID
	const el_listId = document.getElementById('akz-listId');
	// 一覧画面divタグのID
	const el_divId = document.getElementById('akz-divId');
	// 日付フィールド（カンマ区切り）
	const el_dates = document.getElementById('akz-dateFields');
	// 文字色（カンマ区切り）
	const el_textColors = document.getElementById('akz-textColors');
	// 背景色（カンマ区切り）
	const el_backColors = document.getElementById('akz-backColors');
	// カレンダーに表示するタイトルフィールド
	const el_title = document.getElementById('akz-titleField');
	// タイトルの後に表示する文字列（カンマ区切り）
	const el_suffixes = document.getElementById('akz-suffixes');
	// ---------------------------
	// 設定を保存する
	// ---------------------------
	const saveConfig = function() {
		var configObj = {
			listId: hh(el_listId.value),
			divId: hh(el_divId.value),
			dates: hh(el_dates.value),
            textColors: hh(el_textColors.value),
            backColors: hh(el_backColors.value),
			title: hh(el_title.value),
			suffixes: hh(el_suffixes.value)
		};
		kintone.plugin.app.setConfig(configObj);
	};
	// ---------------------------
	// 保存済みの設定値を表示する
	// ---------------------------
	const readConfig = function() {
		let configObj = kintone.plugin.app.getConfig(PLUGIN_ID);
		console.log(configObj);
		// 既に値がセットされている場合は、フィールドに値を表示させる
		el_listId.value = configObj.listId || null;
		el_divId.value = configObj.divId || null;
        el_dates.value = configObj.dates || null;
        el_textColors.value = configObj.textColors || null;
        el_backColors.value = configObj.backColors || null;
		el_title.value = configObj.title || null;
		el_suffixes.value = configObj.suffixes || null;
	};
	// ---------------------------
	// Event listenerの登録
	// ---------------------------
	saveButton.addEventListener('click', saveConfig);
	window.addEventListener('load', readConfig);
	// ---------------------------
	// HTML escape against XSS
	// ---------------------------
	function hh(str) {
		return (str) ? str.replace(/&/g, '&amp;').replace(/</g, '&lt;')
			.replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#39;') : '';
	}
})(kintone.$PLUGIN_ID);
// ----------------------------------------------------------