
/* ------------------------------------------------------------------
 * Configuration of Simple Auto Numbering
 * 2020.5.14
 * 2021.8.21 Version 4 初期値の設定を追加
 * 2021.8.30 Version 5 文字列のコピーを追加
 * 2021.12.19 Version 6
 * 	組織間のアクセスが禁止されているとき、「組織選択」を採番に連結させ重複を避ける
 * 2023.7.3 Version 6.1 編集画面で連番の変更を禁止するかどうかの設定を追加
 * 2024.4.10 Version 6.2 「文字列のコピー」を「文字列／数値のコピー」に変更
 * (C) Akazawa Studio LLC, https://www.akazawa.org
 * ------------------------------------------------------------------*/
(function(PLUGIN_ID) {
	'use strict';
	// ---------------------------
	// HTML escape against XSS
	// ---------------------------
	function hh(str) {
		return str.replace(/&/g, '&amp;').replace(/</g, '&lt;')
			.replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
	}
	// ---------------------------
	// 要素の取得
	// ---------------------------
	// 保存ボタン
	const buttonSave = document.getElementById('akz-save-button');
	// 付番保存先フィールドの選択（selectメニュー）
	const elFieldname0 = document.getElementById('akz-fieldname0'); // 連番保存先
	const elFieldname1 = document.getElementById('akz-fieldname1'); // 桁数を指定した連番の保存先
	// 編集画面で変更を禁止するか(チェックが入っていたら変更禁止)
	const notEdit = document.getElementById('akz-not-edit');
	// 付番桁数（selectメニュー）
	const elDigits = document.getElementById('akz-digits');
	// 組織選択（selectメニュー）
	const elSection = document.getElementById('akz-section');
	const elSectionSaved = document.getElementById('akz-section-saved');
	// Prefix（テキストボックス）
	const elPrefix = document.getElementById('akz-prefix');
	// 初期値（テキストボックス）
	const elInitial = document.getElementById('akz-initial-value');
	// 文字列コピー（selectメニュー）
	const elCopyOriginal = document.getElementById('akz-copy-original');
	const elCopyDestination = document.getElementById('akz-copy-destination');
	// ---------------------------
	// 保存済みの設定値を表示する
	// ---------------------------
	const readConfig = function() {
		let configObj = kintone.plugin.app.getConfig(PLUGIN_ID);
		console.log(configObj);
		// 既に値がセットされている場合は、フィールドに値を表示させる
		if (configObj.fieldcode0) {
			elFieldname0.value = configObj.fieldcode0;
		}
		if (configObj.fieldcode1) {
			elFieldname1.value = configObj.fieldcode1;
		}
		if ('notEdit' in configObj && Boolean(configObj.notEdit)) {
			notEdit.checked = true;
		} else {
			notEdit.checked = false;
		}
		if (configObj.digits) {
			elDigits.value = configObj.digits;
		}
		if (configObj.section) {
			elSection.value = configObj.section;
		}
		if (configObj.sectionSaved) {
			elSectionSaved.value = configObj.sectionSaved;
		}
		if (configObj.prefix) {
			elPrefix.value = configObj.prefix;
		}
		if (configObj.initial) {
			elInitial.value = configObj.initial;
		}
		if (configObj.copyOriginal) {
			elCopyOriginal.value = configObj.copyOriginal;
		}
		if (configObj.copyDestination) {
			elCopyDestination.value = configObj.copyDestination;
		}
	};
	// ---------------------------
	// 設定を保存する
	// ---------------------------
	const saveConfig = function() {
		var init = hh(elInitial.value);
		// 初期値が指定されていない（""）場合または0以下の場合は、1を初期値として設定する
		if (!init || Number(init) < 1) {
			init = "1";
		}
		let notEditValue = "";
		if (notEdit.checked) {
			notEditValue = "true";
		}
		var configObj = {
			fieldcode0: hh(elFieldname0.value),
			fieldcode1: hh(elFieldname1.value),
			notEdit: notEditValue,
			digits: hh(elDigits.value),
			section: hh(elSection.value),
			sectionSaved: hh(elSectionSaved.value),
			prefix: hh(elPrefix.value),
			initial: init,
			copyOriginal: hh(elCopyOriginal.value),
			copyDestination: hh(elCopyDestination.value)
		};
		kintone.plugin.app.setConfig(configObj);
	};
	// ------------------------------------------------------
	// アプリIDからフィールド名とフィールドコードの一覧を取得する
	// （付番を保存するためのフィールドを指定できるように）
	// ------------------------------------------------------
	const getFields = function() {
		var params = {
			'app': kintone.app.getId()
		};
		kintone.api(kintone.api.url('/k/v1/form', true), 'GET', params, function(resp) {
			const prop = resp.properties; // 配列
			const optionNumber = []; // 付番用数値フィールド（候補）のフィールド名
			const optionString = []; // 付番用文字列(1行)フィールド（候補）のフィールド名
			const optionCalc = [];   // 計算フィールド
			const optionSection = []; // 組織選択フィールド（候補）のフィールド名
			optionString.push('<option value="" selected>---</option>');
			optionSection.push('<option value="" selected>---</option>');
			for (let m = 0; m < prop.length; m++) {
				switch (prop[m].type) {
				case 'NUMBER':
					optionNumber.push('<option value="' + prop[m].code + '">'
                        + prop[m].label + '</option>');
					break;
				case 'SINGLE_LINE_TEXT':
					optionString.push('<option value="' + prop[m].code + '">'
                        + prop[m].label + '</option>');
					break;
				case 'ORGANIZATION_SELECT':
					optionSection.push('<option value="' + prop[m].code + '">'
                        + prop[m].label + '</option>');
					break;
				case 'CALC':
					optionCalc.push('<option value="' + prop[m].code + '">'
                        + prop[m].label + '</option>');
					break;
				}
			}
			elFieldname0.innerHTML = optionNumber.join('');
			elFieldname1.innerHTML = optionString.join('');
			elCopyOriginal.innerHTML = optionString.concat(optionNumber).concat(optionCalc).join('');
			elCopyDestination.innerHTML = optionString.concat(optionNumber).join('');
			elSection.innerHTML = optionSection.join('');
			elSectionSaved.innerHTML = optionString.join('');
			readConfig();
		}, function(error) {
			// error
			alert(error.message);
		});
	};
	// ---------------------------
	// Event listenerの登録
	// ---------------------------
	buttonSave.addEventListener('click', saveConfig);
	window.addEventListener('load', getFields);
})(kintone.$PLUGIN_ID);
// ----------------------------------------------------------
