/* --------------------------------------------------------------------
 * PCの一覧画面で各レコードを読み込み、再保存します。
 * - LookUpを再読み込みする機能付き。
 * - mobile では何もしません。
 * 2022.6.15 Ver. 1.0
 * 2023.7.23 Ver. 2.0 LookUpを再読み込みする機能を追加。
 * (C) Akazawa Studio LLC, https://www.akazawa.org
 * --------------------------------------------------------------------*/
(function(PLUGIN_ID) {
	'use strict';
	// --------------------------------------
	// create a kintone client
	// --------------------------------------
	let client = new KintoneRestAPIClient();
	// --------------------------------------
	// アプリIDを取得
	// --------------------------------------
	const appObj = {};
	appObj.APP_ID = kintone.app.getId();
	if (!appObj.APP_ID) {
		// mobile では何もしない
		return;
	}
	// --------------------------------------
	// retrieve config settings.
	// --------------------------------------
	// 設定情報をプラグインの設定から得る
	const configObj = kintone.plugin.app.getConfig(PLUGIN_ID);
	// console.log('configObj:', configObj);
	// Lookupフィールドのフィールドコード
	const LU_field = configObj.lookup;	// 文字列のコピー
	//const copyOriginal = configObj.copyOriginal;
	//const copyDestination = configObj.copyDestination;
	// --------------------------------------
	// レコード一覧画面
	// --------------------------------------
	const event1 = ['app.record.index.show'];
	kintone.events.on(event1, async (ev) => {
		// - - - - - - - - - - - - - - - -
		// メニュー下の空白部分の取得 (PC)
		// - - - - - - - - - - - - - - - -
		let elemBelow = kintone.app.getHeaderSpaceElement(); // PC
		elemBelow.innerHTML = '';
		elemBelow.id = 'akz-header-space-index';
		// - - - - - - - - - - - - - - - -
		// 操作ボタンの設置
		// - - - - - - - - - - - - - - - -
		const button1 = document.createElement('button');
		button1.textContent = '全レコードを再保存';
		button1.id = 'akz-excute-button1';
		elemBelow.appendChild(button1);
		const button2 = document.createElement('button');
		button2.textContent = 'Lookupの再［取得］';
		button2.id = 'akz-excute-button2';
		elemBelow.appendChild(button2);
		// - - - - - - - - - - - - - - - -
		// レコード読み込みと再保存
		// - - - - - - - - - - - - - - - -
		button1.addEventListener('click', async () => {
			// 確認dialog
			const response = await Swal.fire({
				title: '全レコードを読み込んで、再保存',
				text: `実行していいですか？`,
				icon: 'question',
				showCancelButton: true,
				confirmButtonColor: '#08f',
				cancelButtonColor: '#d30',
				reverseButtons:true
			});
			if (!response.isConfirmed) {
				// 何もしない
				return ev;
			}
			Swal.fire({
				icon: 'info',
				title: '処理中...',
				text: '終了するまで画面はそのままにしてください',
				allowOutsideClick: false,	// 枠外をクリックしても閉じない
				showConfirmButton: false,
				didOpen: () => {
					Swal.showLoading();
				}
			});
			let records;
			let newRecords;
			try {
				// 一覧画面に表示されているレコードの取得条件
				const cond = kintone.app.getQueryCondition();
				const getParams = {
					app: appObj.APP_ID,
					query: cond,
					lang: 'default'
				};
				// 全レコードを取得する
				records = await client.record.getAllRecordsWithCursor(getParams);
				// 全レコードを更新する
				const updateRecords = [];
				for (let record of records) {
					const newRecord = {
						id: record.$id.value,
						revision: record.$revision.value
					};
					//newRecord.record = {};
					//newRecord.record[copyDestination] = {};
					//if (copyOriginal && copyDestination) {
					//	newRecord.record[copyDestination].value = record[copyOriginal].value;
					//}
					updateRecords.push(newRecord);
				}
				const updateParams = {
					app:  appObj.APP_ID,
					records: updateRecords
				}
				// console.log(updateParams);
				newRecords = await client.record.updateAllRecords(updateParams);
				console.log(newRecords);
			} catch (error) {
				await Swal.fire({
					title: 'ERROR',
					text: String(error),
					icon: 'error',
					confirmButtonColor: '#d30'
				});
				return;
			}
			await Swal.fire({
				title: '処理終了',
				text: `${newRecords.records.length}件の読み込みと再保存が終わりました！`,
				icon: 'success',
				confirmButtonColor: '#2c2'
			});
			location.reload();
		});
		// - - - - - - - - - - - - - - - -
		// Lookupフィールドの再「取得」
		// - - - - - - - - - - - - - - - -
		button2.addEventListener('click', async () => {
			// 確認dialog
			const response = await Swal.fire({
				title: '全レコードを読み込んで、Lookupフィールドを再「取得」',
				text: `実行していいですか？`,
				icon: 'question',
				showCancelButton: true,
				confirmButtonColor: '#08f',
				cancelButtonColor: '#d30',
				reverseButtons:true
			});
			if (!response.isConfirmed) {
				// 何もしない
				return ev;
			}
			Swal.fire({
				icon: 'info',
				title: '処理中...',
				text: '終了するまで画面はそのままにしてください',
				allowOutsideClick: false,	// 枠外をクリックしても閉じない
				showConfirmButton: false,
				didOpen: () => {
					Swal.showLoading();
				}
			});
			let returnValue;
			try {
				// 一覧画面に表示されているレコードの取得条件
				const cond = kintone.app.getQueryCondition();
				const params_get = {
					app: appObj.APP_ID,
					query: cond,
					lang: 'default'
				};
				// 全レコードを取得する
				const records = await client.record.getAllRecordsWithCursor(params_get);
				// 全レコードについて、Lookupフィールドを再「取得」する
				const params = {
					app: appObj.APP_ID,
					records: []
				};
				for (let i = 0; i < records.length; i++) {
					params.records[i] = {
						id: records[i].$id.value,
						revision: records[i].$revision.value,
						record: {}
					};
					params.records[i].record[LU_field] = {
						value: records[i][LU_field].value
					};
				}
				console.log(params);
				returnValue = await client.record.updateAllRecords(params);
				console.log(returnValue);
			} catch (error) {
				await Swal.fire({
					title: 'ERROR',
					text: String(error),
					icon: 'error',
					confirmButtonColor: '#d30'
				});
				return;
			}
			await Swal.fire({
				title: 'Lookupフィールドの再「取得」終了',
				text: `${returnValue.records.length}件のレコードで再「取得」しました！`,
				icon: 'success',
				confirmButtonColor: '#2c2'
			});
			location.reload();
		});	// button click event handler
	});	// kintone.events
	// --------------------------------------
	// HTML escape against XSS
	// --------------------------------------
	const _hh = (str) => {
		if (str) {
			return str.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
		}
		return str;
	};
})(kintone.$PLUGIN_ID); // ----- function
