/* --------------------------------------------------------------------
 * PCの一覧画面で各レコードに対し、指定したフィールドに値をセットします。
 * - mobile では何もしません。
 * 2022.7.30 Ver. 1.0
 * (C) Akazawa Studio LLC, https://www.akazawa.org
 * --------------------------------------------------------------------*/
(function(PLUGIN_ID) {
	'use strict';
	// --------------------------------------
	// create a kintone client
	// --------------------------------------
	let client = new KintoneRestAPIClient();
	// --------------------------------------
	// アプリIDを取得
	// --------------------------------------
	const appObj = {};
	appObj.APP_ID = kintone.app.getId();
	if (!appObj.APP_ID) {
		// mobile では何もしない
		return;
	}
	// --------------------------------------
	// レコード一覧画面
	// --------------------------------------
	const select_id = 'akz-select';
	const textbox_id = 'akz-textbox';
	const alert = '【全データ破損リスク有り】現在の絞り込み条件で一覧になっている全レコードに対して一括で更新します。【元に戻せません】ので「更新対象のレコードに絞り込まれていること」と「フィールドの指定が正しいこと」を十分に確認してください。「ファイルに書き出す」機能でバックアップを取ってから実行することをお勧めします。利用後はプラグインを【必ず削除】してください。';
	const event1 = ['app.record.index.show'];
	kintone.events.on(event1, async (ev) => {
		const isSelect = document.getElementById(select_id);
		if (isSelect) {
			return ev;	// 既に要素がある場合は何もしない（重複防止）
		}
		// - - - - - - - - - - - - - - - - - - - - - - - -
		// レコード[0]からフィールドコードとフィールドタイプを取得
		// - - - - - - - - - - - - - - - - - - - - - - - -
		if (!ev.records.length) {
			return ev;	// レコードがゼロの場合は何もしない
		}
		// - - - - - - - - - - - - - - - -
		// メニュー下の空白部分の取得 (PC)
		// - - - - - - - - - - - - - - - -
		let elemBelow = kintone.app.getHeaderSpaceElement(); // PC
		elemBelow.textContent = '';
		elemBelow.id = 'akz-header-space-index';
		// - - - - - - - - - - - - - - - -
		// 注意書きの表示
		// - - - - - - - - - - - - - - - -
		const alertDiv = document.createElement('div');
		alertDiv.id = 'akz-alert';
		alertDiv.textContent = alert;
		elemBelow.appendChild(alertDiv);
		// - - - - - - - - - - - - - - - -
		// ドロップダウンリストの設置
		// - - - - - - - - - - - - - - - -
		const select = document.createElement('select');
		select.id = select_id;
		const record0 = ev.records[0];
		for (let code in record0) {
			switch (record0[code].type) {
			case 'SINGLE_LINE_TEXT':
			case 'NUMBER':
			case 'RADIO_BUTTON':
			case 'DROP_DOWN':
			case 'DATE':
			case 'TIME':
			case 'DATETIME':
			case 'LINK':
			case 'CHECK_BOX':
			case 'MULTI_SELECT':
				let node = document.createTextNode(`${code} (${record0[code].value})`);
				let option = document.createElement('option');
				option.appendChild(node);
				option.value = code + "/" + record0[code].type;
				select.appendChild(option);
			default:
			}
		}
		const pluginSelect = document.createElement('div');
		pluginSelect.className = 'kintoneplugin-select';
		const pluginSelectOuter = document.createElement('div');
		pluginSelectOuter.className = 'kintoneplugin-select-outer';
		pluginSelect.appendChild(select);
		pluginSelectOuter.appendChild(pluginSelect);
		elemBelow.appendChild(pluginSelectOuter);
		// - - - - - - - - - - - - - - - -
		// テキストボックスの設置
		// - - - - - - - - - - - - - - - -
		const text = document.createElement('input');
		text.id = textbox_id;
		text.className = 'kintoneplugin-input-text';
		text.type = 'text';
		const inputouter = document.createElement('div');
		inputouter.className = 'kintoneplugin-input-outer';
		inputouter.appendChild(text);
		elemBelow.appendChild(inputouter);
		// - - - - - - - - - - - - - - - -
		// 操作ボタンの設置
		// - - - - - - - - - - - - - - - -
		const button = document.createElement('button');
		button.textContent = 'セットする';
		button.id = 'akz-excute-button';
		button.className = 'kintoneplugin-button-normal';
		elemBelow.appendChild(button);
		// - - - - - - - - - - - - - - - -
		// ボタンクリック：レコード読み込みと保存
		// - - - - - - - - - - - - - - - -
		button.addEventListener('click', async () => {
			// 確認dialog
			const response = await Swal.fire({
				title: '【要確認】絞り込みとフィールド指定は正しいですか？',
				text: '各レコードに値を一括でセットします。テキストボックスが空欄の場合はそのフィールドを空（から）にします。【元に戻せません】いいですか？',
				icon: 'question',
				showCancelButton: true,
				confirmButtonColor: '#08f',
				cancelButtonColor: '#d30',
				reverseButtons:true
			});
			if (!response.isConfirmed) {
				// 何もしない
				return ev;
			}
			Swal.fire({
				icon: 'info',
				title: '処理中...',
				text: '終了するまで画面はそのままにしてください',
				allowOutsideClick: false,	// 枠外をクリックしても閉じない
				showConfirmButton: false,
				didOpen: () => {
					Swal.showLoading();
				}
			});
			// - - - - - - - - - - - - - - - -
			// フィールドと設定値の読み取り
			// - - - - - - - - - - - - - - - -
			const fieldcode = document.getElementById(select_id).value.split('/');
			const fieldvalue = document.getElementById(textbox_id).value;
			// - - - - - - - - - - - - - - - -
			// レコード読み込みと保存
			// - - - - - - - - - - - - - - - -
			let records;
			let newRecords;
			try {
				// 一覧画面に表示されているレコードの取得条件
				const cond = kintone.app.getQueryCondition();
				const getParams = {
					app: appObj.APP_ID,
					query: cond,
					lang: 'default'
				};
				// 全レコードを取得する
				records = await client.record.getAllRecordsWithCursor(getParams);
				// 全レコードを更新する
				const updateRecords = [];
				for (let record of records) {
					const newRecord = {
						id: record.$id.value,
						revision: record.$revision.value,
						record: {}
					};
					if (fieldcode[1] === 'CHECK_BOX' || fieldcode[1] === 'MULTI_SELECT') {
						// 複数選択の場合は「,」区切りなので、分解し前後の空白を削除する。
						const tempArr = fieldvalue.split(',');
						const tempArr2 = [];
						for (let temp of tempArr) {
							tempArr2.push(temp.trim());
						}
						newRecord.record[fieldcode[0]] = { value: tempArr2 };
					} else {
						newRecord.record[fieldcode[0]] = { value: fieldvalue };
					}
					updateRecords.push(newRecord);
				}
				const updateParams = {
					app:  appObj.APP_ID,
					records: updateRecords
				}
				//console.log(updateParams);
				newRecords = await client.record.updateAllRecords(updateParams);
				console.log('更新レコード:', newRecords);
			} catch (error) {
				await Swal.fire({
					title: 'ERROR',
					text: String(error),
					icon: 'error',
					confirmButtonColor: '#d30'
				});
				return;
			}
			await Swal.fire({
				title: '処理終了',
				text: `${newRecords.records.length}件を保存しました！`,
				icon: 'success',
				confirmButtonColor: '#2c2'
			});
			location.reload();
		});
		return ev;
	});	// kintone.events
	// --------------------------------------
	// HTML escape against XSS
	// --------------------------------------
	const _hh = (str) => {
		if (str) {
			return str.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
		}
		return str;
	};
})(kintone.$PLUGIN_ID); // ----- function
