/* ----------------------------------------------------------
 * Configuration of Gsender
 * @Author Toshi Akazawa
 * @Copyright (C) Akazawa Studio LLC, https://www.akazawa.org
 * 2018.6.9
 * 2023.4.25 暗号化キー追加（アクセストークンを保存する時に暗号化する）
 * 2023.4.29 テンプレートを設定画面からkintoneアプリに移行
 * 2023.8.8 評価版用設定プログラムに再編
 * (C) Akazawa Studio LLC
 * https://www.akazawa.org
 * ----------------------------------------------------------*/
(function(PLUGIN_ID) {
	'use strict';
	//------------------------
	// Definition of variables
	//------------------------
	//--保存ボタン
	const buttonSave = document.getElementById('akz-save-button');
	//1.クライアントID & 秘密鍵
	const clientId_el = document.getElementById('akz-clientid');
	const secretKey_el = document.getElementById('akz-key');
	//2.宛先メールアドレス & 最大通数
	const to_fieldname_el = document.getElementById('akz-to-fieldname');
	const max_mail_el = document.getElementById('akz-max-mail');
	//3.メールテンプレートアプリ
	const appId_el = document.getElementById('akz-app-id');
	const appTemplate_el = document.getElementById('akz-app-template-field');
	const appTitle_el = document.getElementById('akz-app-title-field');
	const appContent_el = document.getElementById('akz-app-content-field');
	const appStatusFd_el = document.getElementById('akz-app-status-field');
	const appStatusVal_el = document.getElementById('akz-app-status-value');
	const appOrder_el = document.getElementById('akz-app-order-field');
	//------------------------
	//保存済みの設定値を表示する
	//------------------------
	const read_config = function() {
		let configObj = kintone.plugin.app.getConfig(PLUGIN_ID);
		console.log(configObj);
		//既に値がセットされている場合は、フィールドに値を表示させる
		if (configObj.oauth) {
			clientId_el.value = configObj.oauth;
		}
		if (configObj.key) {
			secretKey_el.value = configObj.key;
		}
		if (configObj.mail) {
			to_fieldname_el.value = configObj.mail;
		}
		if (configObj.max_mail) {
			max_mail_el.value = configObj.max_mail;
		}
		if (configObj.app_id) {
			appId_el.value = configObj.app_id;
		}
		if (configObj.app_template) {
			appTemplate_el.value = configObj.app_template;
		}
		if (configObj.app_title) {
			appTitle_el.value = configObj.app_title;
		}
		if (configObj.app_content) {
			appContent_el.value = configObj.app_content;
		}
		if (configObj.app_status_fd) {
			appStatusFd_el.value = configObj.app_status_fd;
		}
		if (configObj.app_status_val) {
			appStatusVal_el.value = configObj.app_status_val;
		}
		if (configObj.app_order) {
			appOrder_el.value = configObj.app_order;
		}
	};
	//------------------------
	//設定を保存する
	//------------------------
	const save_config = function() {
		const configObj = {
			oauth: _hh(clientId_el.value),
			key: _hh(secretKey_el.value),
			mail: _hh(to_fieldname_el.value),
			max_mail: _hh(max_mail_el.value),
			app_id: _hh(appId_el.value),
			app_template: _hh(appTemplate_el.value),
			app_title: _hh(appTitle_el.value),
			app_content: _hh(appContent_el.value),
			app_status_fd: _hh(appStatusFd_el.value),
			app_status_val: _hh(appStatusVal_el.value),
			app_order: _hh(appOrder_el.value),
		};
		kintone.plugin.app.setConfig(configObj);
		// 設定を保存したときは、ローカルストレージ（保存してあったアクセストークン）を消去する
		localStorage.clear();
	};
	//--------------------------------------------------------
	// アプリIDからフィールド名とフィールドコードの一覧を取得する
	//（宛先メールアドレスが保存されているフィールドを指定できるように）
	//--------------------------------------------------------
	const get_mailaddr_field = function() {
		const params = { 'app': kintone.app.getId() };
		kintone.api(kintone.api.url('/k/v1/form', true), 'GET', params, function(resp) {
			const prop = resp.properties; //配列
			const options_to = []; //宛先メールアドレス用フィールド名
			const options_attach = ['<option value="">添付しない</option>']; //添付ファイルフィールド
			for (let m = 0; m < prop.length; m++) {
				switch (prop[m].type) {
				case 'LINK':
					//MAILのリンクの時、フィールドコードとフィールド名を宛先用プルダウンメニューにセットする
					if (prop[m].protocol === 'MAIL') {
						options_to.push(`<option value="${prop[m].code}">${prop[m].label}</option>`);
					}
					break;
				case 'SINGLE_LINE_TEXT':
				case 'RADIO_BUTTON':
				case 'DROP_DOWN':
					options_to.push(`<option value="${prop[m].code}">${prop[m].label}</option>`);
					break;
				case 'FILE':
					options_attach.push(`<option value="${prop[m].code}">${prop[m].label}</option>`);
					break;
				}
			}
			to_fieldname_el.innerHTML = options_to.join('');
			read_config();
		}, async function(error) {
			await Swal.fire({
				icon: 'error',
				title: 'ERROR',
				text: error,
				confirmButtonColor: '#d30'
			});
		});
	};
	//---------------------------------------------------
	//イベントリスナの登録
	//---------------------------------------------------
	buttonSave.addEventListener('click', save_config);
	window.addEventListener('load', get_mailaddr_field);
	// ---------------------------
	// HTML escape against XSS
	// ---------------------------
	function _hh(str) {
		if (typeof str === 'string') {
			return str.replace(/&/g, '&amp;').replace(/</g, '&lt;')
				.replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
		}
		return str;
	}
})(kintone.$PLUGIN_ID);
//----------------------------------------------------------
