/* ----------------------------------------------------------------------
 * Make fields invisible.
 * (C) Akazawa Studio LLC, https://www.akazawa.org
 * 2021.8.21 Version 1.0
 * 2023.6.18 Version 1.1 kintone-ui-componentをバージョンup（コンフリクト解消）
 * ----------------------------------------------------------------------*/
(function(PLUGIN_ID) {
	'use strict';
	// ---------------------------
	// 定数
	// ---------------------------
	const CHECK_ID = 'akz-checkbox-items';
	const CHECKTABLE_ID = 'akz-checkbox-table-';
	const CHECK_CLASS = 'akz-checkbox-class';
	// kintone UI Component
	const Kuc = Kucs['1.11.0'];
	let elCheckbox; // チェックボックス（一般的なフィールド一覧）
	let elTableId = []; // チェックボックス（テーブル内フィールド一覧）
	// ---------------------------
	// 要素の取得と設置
	// ---------------------------
	// 保存ボタン
	const elButtonSave = document.getElementById('akz-save');
	const buttonSave = new Kuc.Button({
		text: '保存',
		type: 'normal',
		id: 'akz-save-button'
	});
	elButtonSave.appendChild(buttonSave);
	//
	// このHTML要素内に、一般的なFieldを一覧表示する
	const elFieldGeneral = document.getElementById('akz-checkbox');
	// このHTML要素内に、テーブルのFieldを一覧表示する
	const elFieldTable = document.getElementById('akz-checkbox-table');
	// ------------------------------------------------------
	// 保存済みの設定値を取得する
	// @return Object 保存されている内容
	// ------------------------------------------------------
	const readConfig = () => {
		let configObj = kintone.plugin.app.getConfig(PLUGIN_ID);
		console.log('configObj:', configObj);
		// 返値オブジェクト
		const returnObj = {
			fields: [],
			tableCells: [],
			general: '',
			table: ''
		};
		if (configObj.checked) {
			returnObj.fields = configObj.checked.split('&');
		}
		if (configObj.checkedTable) {
			const tempArr = configObj.checkedTable.split('#');
			for (let str of tempArr) {
				returnObj.tableCells.push(str.split('&'));
			}
		}
		returnObj.general = configObj.general;
		returnObj.table = configObj.table;
		return returnObj;
		// for check
		// console.log(kintone.plugin.app.getProxyConfig(URL, 'GET'));
	};
	// ------------------------------------------------------
	// 設定を保存する
	// ------------------------------------------------------
	const saveConfig = function() {
		// チェックボックスのチェック状態を読み込む
		elCheckbox = document.getElementById(CHECK_ID);
		//
		const elCheckboxTables = [];
		for (let tableId of elTableId) {
			elCheckboxTables.push(document.getElementById(tableId));
		}
		// テーブル内フィールドでチェックされているもの（フィールドコード）を連結する
		const tables = [];
		for (let table of elCheckboxTables) {
			tables.push(table.value.join('&'));
		}
		// PC&Mobile か Mobile Only か
		const radioEl1 = document.getElementsByName('general');
		let radioVal1 = '';
		for (let i = 0; i < radioEl1.length; i++) {
			if (radioEl1[i].checked) {
				radioVal1 = radioEl1[i].value;
			}
		}
		const radioEl2 = document.getElementsByName('table');
		let radioVal2 = '';
		for (let i = 0; i < radioEl2.length; i++) {
			if (radioEl2[i].checked) {
				radioVal2 = radioEl2[i].value;
			}
		}
		// 保存するためのオブジェクトを作る
		// フィールドごとの区切りは'&'
		// テーブルごとの区切りは'#'
		const configObj = {};
		configObj.checked = elCheckbox.value.join('&');
		configObj.checkedTable = tables.join('#');
		configObj.general = radioVal1;
		configObj.table = radioVal2;
		kintone.plugin.app.setConfig(configObj);
		/*
		* When executing an external API
		*
		kintone.plugin.app.setConfig(configObj, function() {
			const headers = {
				'X-Cybozu-API-Token': configObj.apitoken
			};
			kintone.plugin.app.setProxyConfig(URL, 'GET', headers, {});	
		});
		*/
	};
	// ------------------------------------------------------
	// フィールド名とフィールドコードの一覧を取得する
	// ------------------------------------------------------
	const getFields = function() {
		var params = {'app': kintone.app.getId()};
		kintone.api(kintone.api.url('/k/v1/form', true), 'GET', params, function(resp) {
			const prop = resp.properties; // 配列
			const items = [];	// フィールドについて、{label: フィールド名, value: フィールドコード}の配列
			const tableItems = []; // 各テーブルについて、「{label: フィールド名, value: フィールドコード}の配列」の配列
			const tableLabels = []; // 各テーブルの名前の配列
			// 保存されている値を読み出す
			const savedObj = readConfig();
			const fields = savedObj.fields;	// チェックされているフィールド
			const tableCells = savedObj.tableCells;	// チェックされているテーブル内フィールド
			for (let i = 0; i < prop.length; i++) {
				switch (prop[i].type) {
					case 'RECORD_NUMBER':	// レコード番号
					case 'CREATOR':	// 作成者
					case 'CREATED_TIME':	// 作成日時
					case 'MODIFIER':	// 更新者
					case 'UPDATED_TIME':	// 更新日時
					case 'SINGLE_LINE_TEXT':	// 文字列（1行）
					case 'NUMBER':	// 数値
					case 'CALC':	// 計算
					case 'MULTI_LINE_TEXT':	// 文字列（複数行）
					case 'RADIO_BUTTON':
					case 'RICH_TEXT':	// リッチエディター
					case 'CHECK_BOX':	// チェックボックス
					case 'RADIO_BUTTON':	// ラジオボタン
					case 'DROP_DOWN':	// ドロップダウン
					case 'MULTI_SELECT':	// 複数選択
					case 'FILE':	// 添付ファイル
					case 'LINK':	// リンク
					case 'DATE':	// 日付
					case 'TIME':	// 時刻
					case 'DATETIME':	// 日時
					case 'USER_SELECT':	// ユーザー選択
					case 'SUBTABLE':	// テーブル
					case 'ORGANIZATION_SELECT':	// 組織選択
					case 'GROUP_SELECT':	// グループ選択
						items.push({label: prop[i].label, value: prop[i].code});
					break;
				}
				// テーブルの場合は、テーブル内フィールドのフィールドコードを指定できるようにする
				if (prop[i].type == 'SUBTABLE') {
					const cells = [];
					for (let field of prop[i].fields) {
						cells.push({label: field.label, value: field.code});
					}
					//if (cells.length > 0) {
						tableItems.push(cells);	// テーブルが複数個ある場合、テーブルごとに配列要素とする
					//}
					tableLabels.push(prop[i].label);	//テーブル名を保存
				}
			}
			// 一般的なフィールドを選択するためのチェックボックスを表示する
			const checkbox = new Kuc.Checkbox({
				items: items,
				value: fields,
				id: CHECK_ID,
				className: CHECK_CLASS,
				itemLayout: 'horizontal'
			});
			elFieldGeneral.append(checkbox);
			// テーブル内のフィールドを選択するためのチェックボックスを表示する
			for (let i = 0; i < tableItems.length; i++) {
				// テーブル名を表示する
				let span = document.createElement('span');
				let label = document.createTextNode(tableLabels[i]);
				span.append(label);
				elFieldTable.append(span);
				// テーブルのセル（フィールド）を表示する
				const checkbox = new Kuc.Checkbox({
					items: tableItems[i],
					value: tableCells[i],
					id: `${CHECKTABLE_ID}${i}`,
					className: CHECK_CLASS,
					itemLayout: 'horizontal'
				});
				elFieldTable.append(checkbox);
				elTableId.push(`${CHECKTABLE_ID}${i}`);
				// テーブルごとに改行する
				let br = document.createElement('br');
				elFieldTable.append(br);
			}
			// PC&Mobile か Mobile Only かを反映させる
			const radioEl1 = document.getElementsByName('general');
			for (let i = 0; i < radioEl1.length; i++) {
				if (radioEl1[i].value === savedObj.general) {
					radioEl1[i].checked = true;
				}
			}
			const radioEl2 = document.getElementsByName('table');
			for (let i = 0; i < radioEl2.length; i++) {
				if (radioEl2[i].value === savedObj.table) {
					radioEl2[i].checked = true;
				}
			}
		}, function(error) {
			alert(error.message);
		});
	};
	// ---------------------------
	// Event listenerの登録
	// ---------------------------
	buttonSave.addEventListener('click', saveConfig);
	window.addEventListener('load', getFields);
	// ---------------------------
	// HTML escape against XSS
	// ---------------------------
	function hh(str) {
		return str.replace(/&/g, '&amp;').replace(/</g, '&lt;')
			.replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
	}
})(kintone.$PLUGIN_ID);
// ----------------------------------------------------------
