/* ========================================================================
 * Make fields invisible.
 * (C) Akazawa Studio LLC, https://www.akazawa.org
 * 2021.8.21 Version 1.0
 * 2023.6.18 Version 1.1 kintone-ui-componentをバージョンup（コンフリクト解消）
 * ======================================================================= */
((PLUGIN_ID) => {
	'use strict';
	// --------------------------------------
	// retrieve config settings of the plugin
	// --------------------------------------
	const configObj = kintone.plugin.app.getConfig(PLUGIN_ID);
	//console.log(configObj);
	let fields = [];
	let tables = [];
	if ('checked' in configObj) {
		fields = configObj.checked.split('&');
	}
	if ('checkedTable' in configObj) {
		tables = configObj.checkedTable.split(/#|&/);
	}
	//console.log('fields:', fields);
	//console.log('tables:', tables);
	// --------------------------------------
	// レコード詳細画面
	// --------------------------------------
	const events1 = ['app.record.detail.show'];
	const events2 = ['mobile.app.record.detail.show'];
	//
	// PC
	//
	kintone.events.on(events1, (ev) => {
		if (configObj.general === 'both') {
		// 通常のフィールドを非表示にする
			for (let code of fields) {
				kintone.app.record.setFieldShown(code, false);
			}
		}
		if (configObj.table === 'both') {
			// テーブル内フィールドを非表示にする
			for (let code of tables) {
				if (!code) {
					continue;
				}
				kintone.app.record.setFieldShown(code, false);
			}
		}
	});
	//
	// Mobile
	//
	kintone.events.on(events2, (ev) => {
		// 通常のフィールドを非表示にする
		for (let code of fields) {
			kintone.mobile.app.record.setFieldShown(code, false);
		}
		// テーブル内フィールドを非表示にする
		for (let code of tables) {
			if (!code) {
				continue;
			}
			kintone.mobile.app.record.setFieldShown(code, false);
		}
	});
	// --------------------------------------
	// HTML escape against XSS
	// --------------------------------------
	const _h = (str) => {
		if (str) {
			return str.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
		}
		return str;
	};
})(kintone.$PLUGIN_ID);