
/* ----------------------------------------------------------
 * Configuration of saveAgain
 * 2022.6.15 Ver. 1.0
 * 2023.7.23 Ver. 2.0 Retrieve Lookup values again.
 * (C) Akazawa Studio LLC, https://www.akazawa.org
 * ----------------------------------------------------------*/
(function(PLUGIN_ID) {
	'use strict';
	// ---------------------------
	// 要素の取得
	// ---------------------------
	// 保存ボタン
	const buttonSave = document.getElementById('akz-save-button');
	// Lookupフィールドの指定
	const elLookup = document.getElementById('akz-lookup');
	// 文字列コピー（selectメニュー）
	//const elCopyOriginal = document.getElementById('akz-copy-original');
	//const elCopyDestination = document.getElementById('akz-copy-destination');
	// ---------------------------
	// 保存済みの設定値を表示する
	// ---------------------------
	const readConfig = function() {
		let configObj = kintone.plugin.app.getConfig(PLUGIN_ID);
		console.log(configObj);
		// 既に値がセットされている場合は、フィールドに値を表示させる
		if (configObj.lookup) {
			elLookup.value = configObj.lookup;
		}
		/* 文字列コピー
		if (configObj.copyOriginal) {
			elCopyOriginal.value = configObj.copyOriginal;
		}
		if (configObj.copyDestination) {
			elCopyDestination.value = configObj.copyDestination;
		}
		*/
	};
	// ---------------------------
	// 設定を保存する
	// ---------------------------
	const saveConfig = function() {
		var configObj = {
			lookup : _hh(elLookup.value)
			//copyOriginal: _hh(elCopyOriginal.value),
			//copyDestination: _hh(elCopyDestination.value)
		};
		kintone.plugin.app.setConfig(configObj);
	};
	// ------------------------------------------------------
	// フィールド名とフィールドコードの一覧を取得する
	// ------------------------------------------------------
	const getFields = function() {
		var params = {
			'app': kintone.app.getId()
		};
		kintone.api(kintone.api.url('/k/v1/form', true), 'GET', params, function(resp) {
			const prop = resp.properties; // 配列
			const fieldsNumber = []; // 数値フィールドのフィールド名
			const fieldsString = []; // 文字列(1行)フィールドのフィールド名
			const fieldsCalc = []; // 計算フィールドのフィールド名
			const fieldsLink = []; // リンクフィールドのフィールド名
			const fieldsRecordNumber = []; // レコード番号フィールドのフィールド名
			const fields = [];
			fields.push('<option value="" selected>---</option>');
			for (let m = 0; m < prop.length; m++) {
				switch (prop[m].type) {
				case 'NUMBER':
				case 'SINGLE_LINE_TEXT':
				case 'CALC':
				case 'LINK':
				case 'RECORD_NUMBER':
					fields.push(`<option value="${prop[m].code}">${prop[m].label}</option>`);
					break;
				}
			}
			//elCopyOriginal.innerHTML = fieldsString.join('');
			//elCopyDestination.innerHTML = fieldsString.join('');
			elLookup.innerHTML = fields.join('');
			readConfig();
		}, function(error) {
			// error
			alert(error.message);
		});
	};
	// ---------------------------
	// Event listenerの登録
	// ---------------------------
	buttonSave.addEventListener('click', saveConfig);
	window.addEventListener('load', getFields);
	// ---------------------------
	// HTML escape against XSS
	// ---------------------------
	function _hh(str) {
		return str.replace(/&/g, '&amp;').replace(/</g, '&lt;')
			.replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
	}
})(kintone.$PLUGIN_ID);
// ----------------------------------------------------------
